<?php
/*------------------------------------------------------------------------

# TZ Portfolio Plus Extension

# ------------------------------------------------------------------------

# Author:    DuongTVTemPlaza

# Copyright: Copyright (C) 2011-2019 TZ Portfolio.com. All Rights Reserved.

# @License - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Website: http://www.tzportfolio.com

# Technical Support:  Forum - https://www.tzportfolio.com/help/forum.html

# Family website: http://www.templaza.com

# Family Support: Forum - https://www.templaza.com/Forums.html

-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die;

$params = JComponentHelper::getParams('com_tz_portfolio_plus');
?>
<script>
    (function($, Joomla){
        $(document).ready(function(){
           $("[data-tp-license-active]").on("click", function(){
               var $this    = $(this),
                    $action = $.data($this[0], "license-action");

               $("[data-tp-license-loading]").removeClass("hide");
               $this.addClass("hide");

               if($action !== "active") {
                   $.ajax({
                       type: "POST",
                       url: "index.php?option=com_tz_portfolio_plus",
                       data: {
                           "task": "license.verify",
                           "token_key": "<?php echo $params -> get('token_key'); ?>"
                       }
                   }).done(function(result){
                       if (result.state == 400) {
                           $('[data-tp-license-error]').html(result.message).removeClass('hide');
                           $("[data-tp-license-loading]").addClass("hide");
                           $this.removeClass("hide");
                           return false;
                       }
                       // Valid licenses
                       if (result.state == 200) {
                           $("[data-licenses-placeholder]").html(result.html);
                           if(result.licenses.length > 1) {
                               $("[data-licenses]").removeClass("hide");
                           }

                           $("[data-tp-license-loading]").addClass("hide");
                           $("[data-tp-license-active]").removeClass("hide");
                           $.data($this[0], "license-action", "active");
                           if(result.licenses.length === 1) {
                               $this.trigger("click");
                           }
                       }
                   });
               }else{
                   $.ajax({
                       type: "POST",
                       url: "index.php?option=com_tz_portfolio_plus",
                       data: {
                           "task": "license.activepro",
                           "license": $("[data-source-license]").val()
                       }
                   }).done(function (result) {
                       $("[data-tp-license-loading]").addClass("hide");

                       if (result.state == 400) {
                           $('[data-tp-license-error]').html(result.message).removeClass('hide');
                           $("[data-tp-license-loading]").addClass("hide");
                           $this.removeClass("hide");
                           return false;
                       }

                       if (result.state == 200) {
                           $("[data-licenses]").addClass("hide");
                           window.location = "index.php?option=com_tz_portfolio_plus";
                       } else {
                           $this.removeClass("hide");
                       }
                   });
               }
           });
        });
    })(jQuery, Joomla);
</script>
<div class="tp-widget tp-license<?php echo $this -> license?' tp-pro':''; ?>">
    <h4 class="title text-uppercase"><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_LICENSE_INFO'); ?></h4>
    <ul class="inside">
        <li class="text-success"><b>TZ Portfolio+ is <?php echo (COM_TZ_PORTFOLIO_PLUS_EDITION == 'free')?'Free':'Pro'; ?> version</b></li>
        <?php if($license = $this -> license){ ?>
            <li>
                <div class="name"><?php echo JText::_('JGLOBAL_TITLE'); ?>:</div>
                <div class="value"><?php echo $license -> title; ?></div>
            </li>
            <li>
                <div class="name"><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_LICENSE'); ?>:</div>
                <div class="value"><?php echo $license -> reference; ?></div></li>
            <li>
                <div class="name"><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_DATE_EXPIRY'); ?>:</div>
                <div class="value"><?php echo $license -> expire; ?><?php
                    if(TZ_Portfolio_PlusHelper::isLicenseExpired('expire')){
                        ?><span class="expired text-danger"><i class="icon-warning"></i><?php
                        echo JText::_('COM_TZ_PORTFOLIO_PLUS_EXPIRED'); ?></span><?php
                    } ?>
                </div>
            </li>
            <li>
                <div class="name"><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_SUPPORT_VALID'); ?>:</div>
                <div class="value"><?php echo $license -> support_expire; ?><?php
                    if(TZ_Portfolio_PlusHelper::isLicenseExpired('support_expire')){
                    ?><span class="expired text-danger"><i class="icon-warning"></i><?php
                        echo JText::_('COM_TZ_PORTFOLIO_PLUS_EXPIRED'); ?></span><?php
                    } ?>
                </div>
            </li>
        <?php }else{ ?>
        <li><p>You have a full access to all features ( premium add-ons, stunning styles, extensions, etc.) and the number of articles are limited at 30</p>
            <p>If you have purchased a license and please get your token key, and activate Pro version.</p>
        </li>
        <?php } ?>

        <?php if((COM_TZ_PORTFOLIO_PLUS_EDITION == 'free') || !$this -> license || ($this -> license &&
                TZ_Portfolio_PlusHelper::isLicenseExpired('expire'))){ ?>
        <li class="actions">
            <a href="javascript:" class="btn btn-danger btn-large" data-tp-license-active><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_ACTIVE_NOW'); ?></a>

            <a href="javascript:void(0);" class="btn btn-danger btn-large loading hide disabled" data-tp-license-loading>
                <span><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_SETUP_LOADING'); ?></span>
                <span class="progress progress-loading"></span>
            </a>
            <div class="hide" data-licenses>
                <p><?php echo JText::_('COM_TZ_PORTFOLIO_PLUS_SETUP_METHOD_SELECT_LICENSE_INFO');?></p>
                <div data-licenses-placeholder></div>
            </div>
            <div class="alert alert-warning hide" data-tp-license-error></div>
        </li>
        <?php } ?>
    </ul>
</div>