<?php
/*------------------------------------------------------------------------

# TZ Portfolio Plus Extension

# ------------------------------------------------------------------------

# Author:    DuongTVTemPlaza

# Copyright: Copyright (C) 2011-2018 TZ Portfolio.com. All Rights Reserved.

# @License - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Website: http://www.tzportfolio.com

# Technical Support:  Forum - https://www.tzportfolio.com/help/forum.html

# Family website: http://www.templaza.com

# Family Support: Forum - https://www.templaza.com/Forums.html

-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die;

class TZ_Portfolio_PlusAddOnMigrationJContentViewDashboard extends JViewLegacy{

    protected   $item;
    protected   $items;
    protected   $component;
    protected   $statistics;
    public      $filterForm;
    protected   $categories;
    protected   $pagination;
    protected   $paginationCat;

    public function display($tpl = null)
    {
        $this -> state          = $this -> get('State');
        $this -> items          = $this -> get('Items');
        $this -> filterForm     = $this->get('FilterForm');
        $this -> pagination     = $this -> get('Pagination');
        $this -> categories     = $this -> get('CategoryItems');
        $this -> paginationCat  = $this -> get('CategoryPagination');
        $this -> statistics     = $this -> get('Statistics');
        $this -> component      = $this -> state -> get($this -> getName().'.component');

        TZ_Portfolio_PlusAddOnMigrationJContentHelper::addSubmenu($this -> getName());

        $this -> addToolbar();

        $this -> sidebar    = JHtmlSidebar::render();

        return parent::display($tpl); // TODO: Change the autogenerated stub
    }

    protected function getIconStates(){
        return array(
            -2 => 'icon-trash',
            0  => 'icon-unpublish',
            1  => 'icon-publish',
            2  => 'icon-archive',
        );
    }

    protected function addToolbar(){
        $user       = TZ_Portfolio_PlusUser::getUser();
        $addonId    = $this -> state -> get($this -> getName().'.addon_id');
        $canDo	    = TZ_Portfolio_PlusHelperAddon_Datas::getActions( $addonId, 'addon','addon');

        if(JComponentHelper::isInstalled($this -> component)) {
            JToolBarHelper::deleteList(null, 'dashboard.purge',
                JText::_('PLG_MIGRATION_JCONTENT_PURGE_HISTORY'));
            JToolbarHelper::custom('dashboard.purges', 'clock', '',
                JText::_('PLG_MIGRATION_JCONTENT_PURGE_ALL_HISTORY'), false);
        }

        if ($user->authorise('core.admin', 'com_tz_portfolio_plus.addon.'.$addonId)
            || $user->authorise('core.options', 'com_tz_portfolio_plus.addon.'.$addonId))
        {
            $addonId    = $this -> state -> get($this -> getName().'.addon_id');
            JToolbarHelper::link('index.php?option=com_tz_portfolio_plus&view=addon&layout=edit&id='.$addonId
                .'&return='.base64_encode('index.php?option=com_tz_portfolio_plus&view=addon_datas&addon_id='.$addonId
                    .'&addon_view='.$this -> getName()), 'JTOOLBAR_OPTIONS','options');
        }

    }
}